<?php
$title = "All Transactions";
include __DIR__ . '/../layouts/main.php';
?>

<div class="mb-8">
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-mono-900 mb-2">📄 All Transactions</h1>
            <p class="text-mono-600">View and manage all your payment transactions</p>
        </div>
        <div class="flex items-center gap-3">
            <a href="index.php" class="px-4 py-2 text-mono-600 hover:text-mono-900 transition-colors">
                ← Back to Dashboard
            </a>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
    <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6">
        <div class="flex items-center justify-between mb-2">
            <h3 class="text-sm font-medium text-mono-600">Total Transactions</h3>
            <span class="text-2xl">📊</span>
        </div>
        <p class="text-2xl font-bold text-mono-900"><?= number_format($totalCount) ?></p>
        <p class="text-xs text-mono-500 mt-1">All time</p>
    </div>
    
    <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6">
        <div class="flex items-center justify-between mb-2">
            <h3 class="text-sm font-medium text-mono-600">Total Amount</h3>
            <span class="text-2xl">💰</span>
        </div>
        <p class="text-2xl font-bold text-mono-900">$<?= number_format($stats['total_amount'] ?? 0, 2) ?></p>
        <p class="text-xs text-mono-500 mt-1">All transactions</p>
    </div>
    
    <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6">
        <div class="flex items-center justify-between mb-2">
            <h3 class="text-sm font-medium text-mono-600">Average Amount</h3>
            <span class="text-2xl">📈</span>
        </div>
        <p class="text-2xl font-bold text-mono-900">$<?= number_format($stats['avg_amount'] ?? 0, 2) ?></p>
        <p class="text-xs text-mono-500 mt-1">Per transaction</p>
    </div>
    
    <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6">
        <div class="flex items-center justify-between mb-2">
            <h3 class="text-sm font-medium text-mono-600">Banks</h3>
            <span class="text-2xl">🏦</span>
        </div>
        <p class="text-2xl font-bold text-mono-900"><?= $stats['bank_count'] ?? 0 ?></p>
        <p class="text-xs text-mono-500 mt-1">Different banks</p>
    </div>
</div>

<!-- Filters and Search -->
<div class="bg-white rounded-lg shadow-sm border border-mono-200 p-6 mb-6">
    <form method="GET" action="transaction-list.php" class="space-y-4">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <!-- Search -->
            <div class="md:col-span-2">
                <label for="search" class="block text-sm font-medium text-mono-700 mb-2">Search</label>
                <input type="text" 
                       id="search" 
                       name="search" 
                       value="<?= htmlspecialchars($search, ENT_QUOTES, 'UTF-8') ?>"
                       placeholder="Search by payer, merchant, or reference..."
                       class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
            </div>
            
            <!-- Bank Filter -->
            <div>
                <label for="bank" class="block text-sm font-medium text-mono-700 mb-2">Bank</label>
                <select id="bank" 
                        name="bank"
                        class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none">
                    <option value="">All Banks</option>
                    <?php foreach ($uniqueBanks as $b): ?>
                        <option value="<?= htmlspecialchars($b, ENT_QUOTES, 'UTF-8') ?>" 
                                <?= $bank === $b ? 'selected' : '' ?>>
                            <?= htmlspecialchars($b, ENT_QUOTES, 'UTF-8') ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <!-- Date Range -->
            <div>
                <label class="block text-sm font-medium text-mono-700 mb-2">Date Range</label>
                <div class="flex gap-2">
                    <input type="date" 
                           name="date_from" 
                           value="<?= htmlspecialchars($dateFrom, ENT_QUOTES, 'UTF-8') ?>"
                           class="flex-1 px-3 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none text-sm">
                    <input type="date" 
                           name="date_to" 
                           value="<?= htmlspecialchars($dateTo, ENT_QUOTES, 'UTF-8') ?>"
                           class="flex-1 px-3 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none text-sm">
                </div>
            </div>
        </div>
        
        <div class="flex items-center gap-3">
            <button type="submit" 
                    class="px-6 py-2 bg-mono-900 text-white rounded-lg hover:bg-mono-800 transition-colors font-medium">
                🔍 Apply Filters
            </button>
            <?php if (!empty($search) || !empty($bank) || !empty($dateFrom) || !empty($dateTo)): ?>
                <a href="transaction-list.php" 
                   class="px-6 py-2 bg-mono-200 text-mono-700 rounded-lg hover:bg-mono-300 transition-colors font-medium">
                    ✖️ Clear Filters
                </a>
            <?php endif; ?>
        </div>
    </form>
</div>

<!-- Transactions Table -->
<div class="bg-white rounded-lg shadow-sm border border-mono-200 overflow-hidden">
    <div class="p-6 border-b border-mono-200 flex justify-between items-center">
        <h2 class="text-lg font-semibold text-mono-900">
            Transactions 
            <span class="text-sm font-normal text-mono-500">
                (<?= number_format($totalCount) ?> total)
            </span>
        </h2>
        <div class="text-sm text-mono-600">
            Showing <?= $totalCount > 0 ? ($offset + 1) : 0 ?> - <?= min($offset + $perPage, $totalCount) ?> of <?= number_format($totalCount) ?>
        </div>
    </div>
    
    <?php if (empty($data)) : ?>
        <div class="py-16 text-center">
            <div class="text-6xl mb-4">📭</div>
            <p class="text-xl font-semibold text-mono-900 mb-2">No transactions found</p>
            <p class="text-mono-600 mb-6">
                <?php if (!empty($search) || !empty($bank) || !empty($dateFrom)): ?>
                    Try adjusting your filters or search criteria.
                <?php else: ?>
                    Start receiving payments via Telegram to see transactions here.
                <?php endif; ?>
            </p>
            <?php if (!empty($search) || !empty($bank) || !empty($dateFrom)): ?>
                <a href="transaction-list.php" class="inline-block px-6 py-2 bg-mono-900 text-white rounded-lg hover:bg-mono-800 transition-colors">
                    Clear Filters
                </a>
            <?php endif; ?>
        </div>
    <?php else: ?>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-mono-50 border-b border-mono-200">
                    <tr>
                        <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Date & Time</th>
                        <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Payer</th>
                        <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Bank</th>
                        <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Merchant</th>
                        <th class="text-left py-4 px-6 text-sm font-semibold text-mono-700">Reference</th>
                        <th class="text-right py-4 px-6 text-sm font-semibold text-mono-700">Amount</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-mono-100">
                    <?php foreach ($data as $row) : ?>
                        <tr class="hover:bg-mono-50 transition-colors">
                            <td class="py-4 px-6">
                                <div class="text-sm text-mono-900 font-medium">
                                    <?= date("M j, Y", strtotime($row['date'] ?? 'now')) ?>
                                </div>
                                <div class="text-xs text-mono-500">
                                    <?= date("g:i A", strtotime($row['time'] ?? '00:00:00')) ?>
                                </div>
                            </td>
                            <td class="py-4 px-6">
                                <div class="text-sm text-mono-900 font-medium">
                                    <?= htmlspecialchars($row['payer_name'] ?? 'N/A', ENT_QUOTES, 'UTF-8') ?>
                                </div>
                            </td>
                            <td class="py-4 px-6">
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium 
                                    <?= ($row['bank'] ?? '') === 'ABA' ? 'bg-blue-100 text-blue-800' : 'bg-green-100 text-green-800' ?>">
                                    <?= htmlspecialchars($row['bank'] ?? 'N/A', ENT_QUOTES, 'UTF-8') ?>
                                </span>
                            </td>
                            <td class="py-4 px-6">
                                <div class="text-sm text-mono-700">
                                    <?= htmlspecialchars($row['merchant'] ?? 'N/A', ENT_QUOTES, 'UTF-8') ?>
                                </div>
                            </td>
                            <td class="py-4 px-6">
                                <div class="text-xs text-mono-500 font-mono">
                                    <?= htmlspecialchars($row['reference_id'] ?? 'N/A', ENT_QUOTES, 'UTF-8') ?>
                                </div>
                            </td>
                            <td class="py-4 px-6 text-right">
                                <div class="text-sm font-bold text-mono-900">
                                    $<?= number_format($row['amount'] ?? 0, 2) ?>
                                </div>
                                <div class="text-xs text-mono-500">USD</div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        
        <!-- Pagination -->
        <?php if ($totalPages > 1): ?>
            <div class="px-6 py-4 border-t border-mono-200 bg-mono-50">
                <div class="flex items-center justify-between">
                    <div class="text-sm text-mono-600">
                        Page <?= $page ?> of <?= $totalPages ?>
                    </div>
                    <div class="flex items-center gap-2">
                        <?php if ($page > 1): ?>
                            <a href="?page=<?= $page - 1 ?><?= !empty($search) ? '&search=' . urlencode($search) : '' ?><?= !empty($bank) ? '&bank=' . urlencode($bank) : '' ?><?= !empty($dateFrom) ? '&date_from=' . urlencode($dateFrom) : '' ?><?= !empty($dateTo) ? '&date_to=' . urlencode($dateTo) : '' ?>" 
                               class="px-4 py-2 bg-white border border-mono-300 text-mono-700 rounded-lg hover:bg-mono-100 transition-colors text-sm font-medium">
                                ← Previous
                            </a>
                        <?php endif; ?>
                        
                        <div class="flex gap-1">
                            <?php
                            $startPage = max(1, $page - 2);
                            $endPage = min($totalPages, $page + 2);
                            
                            if ($startPage > 1): ?>
                                <a href="?page=1<?= !empty($search) ? '&search=' . urlencode($search) : '' ?><?= !empty($bank) ? '&bank=' . urlencode($bank) : '' ?><?= !empty($dateFrom) ? '&date_from=' . urlencode($dateFrom) : '' ?><?= !empty($dateTo) ? '&date_to=' . urlencode($dateTo) : '' ?>" 
                                   class="px-3 py-2 bg-white border border-mono-300 text-mono-700 rounded-lg hover:bg-mono-100 transition-colors text-sm">
                                    1
                                </a>
                                <?php if ($startPage > 2): ?>
                                    <span class="px-3 py-2 text-mono-500">...</span>
                                <?php endif; ?>
                            <?php endif; ?>
                            
                            <?php for ($i = $startPage; $i <= $endPage; $i++): ?>
                                <?php if ($i == $page): ?>
                                    <span class="px-3 py-2 bg-mono-900 text-white rounded-lg text-sm font-medium">
                                        <?= $i ?>
                                    </span>
                                <?php else: ?>
                                    <a href="?page=<?= $i ?><?= !empty($search) ? '&search=' . urlencode($search) : '' ?><?= !empty($bank) ? '&bank=' . urlencode($bank) : '' ?><?= !empty($dateFrom) ? '&date_from=' . urlencode($dateFrom) : '' ?><?= !empty($dateTo) ? '&date_to=' . urlencode($dateTo) : '' ?>" 
                                       class="px-3 py-2 bg-white border border-mono-300 text-mono-700 rounded-lg hover:bg-mono-100 transition-colors text-sm">
                                        <?= $i ?>
                                    </a>
                                <?php endif; ?>
                            <?php endfor; ?>
                            
                            <?php if ($endPage < $totalPages): ?>
                                <?php if ($endPage < $totalPages - 1): ?>
                                    <span class="px-3 py-2 text-mono-500">...</span>
                                <?php endif; ?>
                                <a href="?page=<?= $totalPages ?><?= !empty($search) ? '&search=' . urlencode($search) : '' ?><?= !empty($bank) ? '&bank=' . urlencode($bank) : '' ?><?= !empty($dateFrom) ? '&date_from=' . urlencode($dateFrom) : '' ?><?= !empty($dateTo) ? '&date_to=' . urlencode($dateTo) : '' ?>" 
                                   class="px-3 py-2 bg-white border border-mono-300 text-mono-700 rounded-lg hover:bg-mono-100 transition-colors text-sm">
                                    <?= $totalPages ?>
                                </a>
                            <?php endif; ?>
                        </div>
                        
                        <?php if ($page < $totalPages): ?>
                            <a href="?page=<?= $page + 1 ?><?= !empty($search) ? '&search=' . urlencode($search) : '' ?><?= !empty($bank) ? '&bank=' . urlencode($bank) : '' ?><?= !empty($dateFrom) ? '&date_from=' . urlencode($dateFrom) : '' ?><?= !empty($dateTo) ? '&date_to=' . urlencode($dateTo) : '' ?>" 
                               class="px-4 py-2 bg-white border border-mono-300 text-mono-700 rounded-lg hover:bg-mono-100 transition-colors text-sm font-medium">
                                Next →
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    <?php endif; ?>
</div>

<?php include __DIR__ . '/../layouts/footer.php'; ?>
