<?php
$billingPeriod = $_GET['period'] ?? 'monthly';
$isAnnual = $billingPeriod === 'annual';
?>

<div class="mb-8">
    <div class="text-center">
        <h1 class="text-4xl font-bold text-mono-900 mb-4">Choose Your Plan</h1>
        <p class="text-lg text-mono-600 mb-6">Select the perfect plan for your business needs</p>
        
        <!-- Billing Period Toggle -->
        <div class="inline-flex items-center bg-mono-200 rounded-lg p-1 mb-8">
            <a href="?period=monthly" 
               class="px-6 py-2 rounded-md text-sm font-medium transition-all <?= !$isAnnual ? 'bg-white text-mono-900 shadow-sm' : 'text-mono-600 hover:text-mono-900' ?>">
                Monthly
            </a>
            <a href="?period=annual" 
               class="px-6 py-2 rounded-md text-sm font-medium transition-all <?= $isAnnual ? 'bg-white text-mono-900 shadow-sm' : 'text-mono-600 hover:text-mono-900' ?>">
                Annual
                <span class="ml-1 text-xs bg-green-100 text-green-700 px-2 py-0.5 rounded-full">Save 17%</span>
            </a>
        </div>
    </div>
</div>

<!-- Pricing Cards -->
<?php if (empty($plans)): ?>
    <div class="bg-white rounded-lg shadow-sm border border-mono-200 p-12 text-center">
        <p class="text-mono-600 mb-4">No pricing plans available at the moment.</p>
        <p class="text-sm text-mono-500">Please check back later or contact support.</p>
    </div>
<?php else: ?>
    <div class="grid grid-cols-1 md:grid-cols-<?= min(count($plans), 3) ?> gap-8 mb-12">
        <?php foreach ($plans as $index => $plan): ?>
            <?php
            $features = json_decode($plan['features'] ?? '[]', true);
            $price = $isAnnual ? ($plan['price_annual'] ?? 0) : ($plan['price_monthly'] ?? 0);
            $monthlyEquivalent = $isAnnual ? (($plan['price_annual'] ?? 0) / 12) : ($plan['price_monthly'] ?? 0);
            // Mark middle plan as popular if there are 3+ plans, otherwise mark the last one
            $isPopular = (count($plans) >= 3 && $index === 1) || (count($plans) < 3 && $index === count($plans) - 1);
            $currentPlan = $currentSubscription && $currentSubscription['plan_id'] == $plan['id'];
            ?>
        
        <div class="relative bg-white rounded-xl shadow-lg border-2 <?= $isPopular ? 'border-mono-900 scale-105' : 'border-mono-200' ?> p-8 hover:shadow-xl transition-all">
            <?php if ($isPopular): ?>
                <div class="absolute -top-4 left-1/2 transform -translate-x-1/2">
                    <span class="bg-mono-900 text-white px-4 py-1 rounded-full text-sm font-semibold">Most Popular</span>
                </div>
            <?php endif; ?>
            
            <?php if ($currentPlan): ?>
                <div class="absolute top-4 right-4">
                    <span class="bg-green-100 text-green-700 px-3 py-1 rounded-full text-xs font-semibold">Current Plan</span>
                </div>
            <?php endif; ?>

            <div class="text-center mb-6">
                <h3 class="text-2xl font-bold text-mono-900 mb-2"><?= htmlspecialchars($plan['name']) ?></h3>
                <p class="text-mono-600 text-sm mb-4"><?= htmlspecialchars($plan['description']) ?></p>
                
                <div class="mb-4">
                    <span class="text-5xl font-bold text-mono-900">$<?= number_format($price, 2) ?></span>
                    <span class="text-mono-600">/<?= $isAnnual ? 'year' : 'month' ?></span>
                </div>
                
                <?php if ($isAnnual): ?>
                    <p class="text-sm text-mono-500">$<?= number_format($monthlyEquivalent, 2) ?>/month billed annually</p>
                <?php endif; ?>
            </div>

            <ul class="space-y-3 mb-8">
                <?php if (is_array($features)): ?>
                    <?php foreach ($features as $feature): ?>
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-green-500 mr-3 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            <span class="text-mono-700 text-sm"><?= htmlspecialchars($feature) ?></span>
                        </li>
                    <?php endforeach; ?>
                <?php endif; ?>
                
                <?php if ($plan['max_transactions']): ?>
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-3 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                        <span class="text-mono-700 text-sm">Up to <?= number_format($plan['max_transactions']) ?> transactions/month</span>
                    </li>
                <?php else: ?>
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-3 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                        <span class="text-mono-700 text-sm">Unlimited transactions</span>
                    </li>
                <?php endif; ?>
                
                <?php if ($plan['max_users']): ?>
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-3 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                        <span class="text-mono-700 text-sm">Up to <?= $plan['max_users'] ?> team members</span>
                    </li>
                <?php else: ?>
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-3 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                        <span class="text-mono-700 text-sm">Unlimited team members</span>
                    </li>
                <?php endif; ?>
            </ul>

            <?php if ($currentPlan): ?>
                <button disabled class="w-full bg-mono-300 text-mono-600 py-3 px-4 rounded-lg font-medium cursor-not-allowed">
                    Current Plan
                </button>
            <?php else: ?>
                <form method="POST" action="pricing.php" class="mt-auto">
                    <input type="hidden" name="plan_id" value="<?= $plan['id'] ?>">
                    <input type="hidden" name="billing_period" value="<?= $billingPeriod ?>">
                    <button type="submit" 
                            class="w-full <?= $isPopular ? 'bg-mono-900 hover:bg-mono-800' : 'bg-mono-700 hover:bg-mono-600' ?> text-white py-3 px-4 rounded-lg font-medium transition-colors">
                        <?= $currentSubscription ? 'Upgrade Plan' : 'Get Started' ?>
                    </button>
                </form>
            <?php endif; ?>
        </div>
    <?php endforeach; ?>
    </div>
<?php endif; ?>

<!-- FAQ Section -->
<div class="bg-white rounded-xl shadow-sm border border-mono-200 p-8 mb-8">
    <h2 class="text-2xl font-bold text-mono-900 mb-6 text-center">Frequently Asked Questions</h2>
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <h3 class="font-semibold text-mono-900 mb-2">Can I change plans later?</h3>
            <p class="text-mono-600 text-sm">Yes, you can upgrade or downgrade your plan at any time. Changes will be prorated.</p>
        </div>
        
        <div>
            <h3 class="font-semibold text-mono-900 mb-2">What payment methods do you accept?</h3>
            <p class="text-mono-600 text-sm">We accept all major credit cards and PayPal. Enterprise plans can be invoiced.</p>
        </div>
        
        <div>
            <h3 class="font-semibold text-mono-900 mb-2">Is there a free trial?</h3>
            <p class="text-mono-600 text-sm">Yes! All plans come with a 14-day free trial. No credit card required.</p>
        </div>
        
        <div>
            <h3 class="font-semibold text-mono-900 mb-2">Can I cancel anytime?</h3>
            <p class="text-mono-600 text-sm">Absolutely. Cancel anytime with no penalties. You'll retain access until the end of your billing period.</p>
        </div>
    </div>
</div>

<!-- CTA Section -->
<div class="text-center bg-mono-900 rounded-xl p-12 text-white">
    <h2 class="text-3xl font-bold mb-4">Ready to get started?</h2>
    <p class="text-mono-300 mb-6 text-lg">Join thousands of businesses already using our platform</p>
    <?php if (!Session::isAuthenticated()): ?>
        <a href="register.php" class="inline-block bg-white text-mono-900 px-8 py-3 rounded-lg font-semibold hover:bg-mono-100 transition-colors">
            Start Free Trial
        </a>
    <?php else: ?>
        <a href="index.php" class="inline-block bg-white text-mono-900 px-8 py-3 rounded-lg font-semibold hover:bg-mono-100 transition-colors">
            Go to Dashboard
        </a>
    <?php endif; ?>
</div>

