<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($title ?? 'Dashboard') ?> - Payment System</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'mono': {
                            50: '#fafafa',
                            100: '#f5f5f5',
                            200: '#e5e5e5',
                            300: '#d4d4d4',
                            400: '#a3a3a3',
                            500: '#737373',
                            600: '#525252',
                            700: '#404040',
                            800: '#262626',
                            900: '#171717',
                            950: '#0a0a0a',
                        }
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-mono-50 min-h-screen flex flex-col">
    <div class="flex flex-1 overflow-hidden">
        <!-- Sidebar Navigation -->
        <aside class="w-64 bg-mono-900 text-mono-100 flex flex-col border-r border-mono-800 flex-shrink-0">
            <div class="p-6 border-b border-mono-800">
                <h1 class="text-xl font-bold text-mono-50">💳 Payment System</h1>
                <p class="text-sm text-mono-400 mt-1">Transaction Tracker</p>
            </div>
            
            <nav class="flex-1 p-4 space-y-1 overflow-y-auto">
                <a href="index.php" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (basename($_SERVER['PHP_SELF']) == 'index.php') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">🏠</span>
                    <span>Dashboard</span>
                </a>
                
                <div class="pt-4 pb-2">
                    <p class="px-4 text-xs font-semibold text-mono-500 uppercase tracking-wider">Reports</p>
                </div>
                
                <a href="summary.php?type=daily" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (isset($_GET['type']) && $_GET['type'] == 'daily') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">📅</span>
                    <span>Daily Summary</span>
                </a>
                
                <a href="summary.php?type=weekly" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (isset($_GET['type']) && $_GET['type'] == 'weekly') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">📆</span>
                    <span>Weekly Summary</span>
                </a>
                
                <a href="summary.php?type=monthly" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (isset($_GET['type']) && $_GET['type'] == 'monthly') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">🗓️</span>
                    <span>Monthly Summary</span>
                </a>
                
                <a href="summary.php?type=yearly" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (isset($_GET['type']) && $_GET['type'] == 'yearly') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">📘</span>
                    <span>Yearly Summary</span>
                </a>
                
                <div class="pt-4 pb-2">
                    <p class="px-4 text-xs font-semibold text-mono-500 uppercase tracking-wider">Transactions</p>
                </div>
                
                <a href="transaction-list.php" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (basename($_SERVER['PHP_SELF']) == 'transaction-list.php') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">📄</span>
                    <span>All Transactions</span>
                </a>
                
                <div class="pt-4 pb-2">
                    <p class="px-4 text-xs font-semibold text-mono-500 uppercase tracking-wider">Settings</p>
                </div>
                
                <a href="settings.php" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (basename($_SERVER['PHP_SELF']) == 'settings.php') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">⚙️</span>
                    <span>Settings</span>
                </a>
                
                <a href="pricing.php" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (basename($_SERVER['PHP_SELF']) == 'pricing.php') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">💳</span>
                    <span>Pricing</span>
                </a>
                
                <div class="pt-4 pb-2">
                    <p class="px-4 text-xs font-semibold text-mono-500 uppercase tracking-wider">Admin</p>
                </div>
                
                <a href="admin-plans.php" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (basename($_SERVER['PHP_SELF']) == 'admin-plans.php') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">💳</span>
                    <span>Manage Plans</span>
                </a>
                
                <a href="admin-users.php" class="flex items-center gap-3 px-4 py-1 rounded-lg text-mono-200 hover:bg-mono-800 hover:text-mono-50 transition-colors <?= (basename($_SERVER['PHP_SELF']) == 'admin-users.php') ? 'bg-mono-800 text-mono-50' : '' ?>">
                    <span class="text-lg">👥</span>
                    <span>Manage Users</span>
                </a>
            </nav>
            
            <div class="p-4 border-t border-mono-800 flex-shrink-0">
                <div class="text-xs text-mono-500">
                    <p>System Status</p>
                    <p class="text-mono-400 mt-1">✓ Operational</p>
                </div>
            </div>
        </aside>

        <!-- Main Content -->
        <main class="flex-1 overflow-y-auto flex flex-col">
            <!-- Top Header with User Info -->
            <div class="bg-white border-b border-mono-200 px-8 py-4 flex-shrink-0">
                <div class="flex justify-end items-center gap-4">
                    <div class="flex items-center gap-3">
                        <div class="text-right">
                            <p class="text-sm font-medium text-mono-900"><?= htmlspecialchars(Session::getUser()['name'] ?? 'User') ?></p>
                            <p class="text-xs text-mono-500"><?= htmlspecialchars(Session::getUser()['email'] ?? '') ?></p>
                        </div>
                        <div class="w-10 h-10 rounded-full bg-mono-700 flex items-center justify-center text-white font-semibold">
                            <?= strtoupper(substr(Session::getUser()['name'] ?? 'U', 0, 1)) ?>
                        </div>
                        <a href="logout.php" class="text-sm text-mono-600 hover:text-mono-900 font-medium transition-colors">
                            Sign Out
                        </a>
                    </div>
                </div>
            </div>
            
            <div class="flex-1 p-8 pb-4">
