<?php

function renderTable($data)
{
    if (empty($data)) {
        echo "<p>No transactions found.</p>";
        return;
    }

    echo "<table border='1' cellspacing='0' cellpadding='6' style='width:100%; margin-top:10px;'>";
    echo "<tr>
            <th>Date</th>
            <th>Time</th>
            <th>Payer</th>
            <th>Bank</th>
            <th>Amount</th>
            <th>Merchant</th>
            <th>Reference</th>
          </tr>";

    foreach ($data as $row) {
        $date = htmlspecialchars($row['date'] ?? '', ENT_QUOTES, 'UTF-8');
        $time = htmlspecialchars($row['time'] ?? '', ENT_QUOTES, 'UTF-8');
        $payer = htmlspecialchars($row['payer_name'] ?? '', ENT_QUOTES, 'UTF-8');
        $bank = htmlspecialchars($row['bank'] ?? '', ENT_QUOTES, 'UTF-8');
        $amount = htmlspecialchars($row['amount'] ?? '0', ENT_QUOTES, 'UTF-8');
        $merchant = htmlspecialchars($row['merchant'] ?? '', ENT_QUOTES, 'UTF-8');
        $reference = htmlspecialchars($row['reference_id'] ?? '', ENT_QUOTES, 'UTF-8');
        
        echo "<tr>
                <td>{$date}</td>
                <td>{$time}</td>
                <td>{$payer}</td>
                <td>{$bank}</td>
                <td>{$amount} USD</td>
                <td>{$merchant}</td>
                <td>{$reference}</td>
              </tr>";
    }

    echo "</table>";
}
