<div class="bg-white rounded-lg shadow-lg p-8 border border-mono-200">
    <div class="text-center mb-8">
        <h1 class="text-3xl font-bold text-mono-900 mb-2">💳 Payment System</h1>
        <h2 class="text-xl text-mono-600">Create your account</h2>
    </div>

    <?php if ($errors = Session::flash('errors')): ?>
        <div class="mb-4 p-4 bg-red-50 border border-red-200 rounded-lg">
            <ul class="list-disc list-inside text-red-700 text-sm space-y-1">
                <?php foreach ($errors as $error): ?>
                    <li><?= htmlspecialchars($error) ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>

    <?php if ($error = Session::flash('error')): ?>
        <div class="mb-4 p-4 bg-red-50 border border-red-200 rounded-lg text-red-700 text-sm">
            <?= htmlspecialchars($error) ?>
        </div>
    <?php endif; ?>

    <form method="POST" action="register.php" class="space-y-6">
        <div>
            <label for="name" class="block text-sm font-medium text-mono-700 mb-2">Full Name</label>
            <input type="text" id="name" name="name" required 
                   class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none"
                   placeholder="John Doe">
        </div>

        <div>
            <label for="email" class="block text-sm font-medium text-mono-700 mb-2">Email address</label>
            <input type="email" id="email" name="email" required 
                   class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none"
                   placeholder="you@example.com">
        </div>

        <div>
            <label for="organization_name" class="block text-sm font-medium text-mono-700 mb-2">Organization Name</label>
            <input type="text" id="organization_name" name="organization_name" required 
                   class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none"
                   placeholder="My Company">
            <p class="mt-1 text-xs text-mono-500">This will be your organization's name</p>
        </div>

        <div>
            <label for="password" class="block text-sm font-medium text-mono-700 mb-2">Password</label>
            <input type="password" id="password" name="password" required minlength="8"
                   class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none"
                   placeholder="••••••••">
            <p class="mt-1 text-xs text-mono-500">Must be at least 8 characters</p>
        </div>

        <div>
            <label for="password_confirm" class="block text-sm font-medium text-mono-700 mb-2">Confirm Password</label>
            <input type="password" id="password_confirm" name="password_confirm" required minlength="8"
                   class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none"
                   placeholder="••••••••">
        </div>

        <button type="submit" 
                class="w-full bg-mono-900 text-white py-3 px-4 rounded-lg font-medium hover:bg-mono-800 focus:outline-none focus:ring-2 focus:ring-mono-500 focus:ring-offset-2 transition-colors">
            Create Account
        </button>
    </form>

    <div class="mt-6 text-center">
        <p class="text-sm text-mono-600">
            Already have an account?
            <a href="login.php" class="font-medium text-mono-900 hover:text-mono-700">Sign in</a>
        </p>
    </div>
</div>

