<?php

// Autoload all necessary classes
spl_autoload_register(function ($class) {
    $base_path = __DIR__ . '/../app/';

    $paths = [
        "Controllers/$class.php",
        "Models/$class.php",
        "Helpers/$class.php",
        "Services/$class.php",
        "Auth/$class.php",
        "Auth/Controllers/$class.php",
        "Middleware/$class.php",
    ];

    foreach ($paths as $path) {
        $full = $base_path . $path;
        if (file_exists($full)) {
            require_once $full;
            return;
        }
    }
});

// Load shared configurations and database connection
$app = require __DIR__ . '/../app/Config/app.php';
$pdo = require __DIR__ . '/../app/Config/db.php';
