<?php
require_once __DIR__ . '/../routes/web.php';

Authenticate::handle();

$settings = new SettingsController($pdo);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    switch ($action) {
        case 'update_organization':
            $settings->updateOrganization();
            break;
        case 'add_telegram_access':
            $settings->addTelegramAccess();
            break;
        case 'delete_telegram_access':
            $settings->deleteTelegramAccess();
            break;
        case 'toggle_telegram_access':
            $settings->toggleTelegramAccess();
            break;
        default:
            header('Location: settings.php');
            exit;
    }
} else {
    $settings->index();
}

