<?php

class TelegramService
{
    public static function sendMessage($chatId, $text, $token = null)
    {
        if ($token === null) {
            $config = require __DIR__ . '/../Config/app.php';
            $token = $config['bot_token'];
        }

        if (empty($token) || $token === 'YOUR_TELEGRAM_BOT_TOKEN_HERE') {
            Functions::logError("Telegram bot token not configured.");
            return false;
        }

        $url = "https://api.telegram.org/bot{$token}/sendMessage";
        $params = http_build_query([
            'chat_id' => $chatId,
            'text' => $text
        ]);

        $context = stream_context_create([
            'http' => [
                'method' => 'GET',
                'timeout' => 5
            ]
        ]);

        $result = @file_get_contents($url . '?' . $params, false, $context);
        
        if ($result === false) {
            Functions::logError("Failed to send Telegram message to chat_id: $chatId");
            return false;
        }

        return true;
    }
}
