<div class="bg-white rounded-lg shadow-lg p-8 border border-mono-200">
    <div class="text-center mb-8">
        <h1 class="text-3xl font-bold text-mono-900 mb-2">💳 Payment System</h1>
        <h2 class="text-xl text-mono-600">Sign in to your account</h2>
    </div>

    <?php if ($error = Session::flash('error')): ?>
        <div class="mb-4 p-4 bg-red-50 border border-red-200 rounded-lg text-red-700 text-sm">
            <?= htmlspecialchars($error) ?>
        </div>
    <?php endif; ?>

    <?php if ($success = Session::flash('success')): ?>
        <div class="mb-4 p-4 bg-green-50 border border-green-200 rounded-lg text-green-700 text-sm">
            <?= htmlspecialchars($success) ?>
        </div>
    <?php endif; ?>

    <form method="POST" action="login.php" class="space-y-6">
        <?= Security::csrfField() ?>
        <div>
            <label for="email" class="block text-sm font-medium text-mono-700 mb-2">Email address</label>
            <input type="email" id="email" name="email" required 
                   class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none"
                   placeholder="you@example.com">
        </div>

        <div>
            <label for="password" class="block text-sm font-medium text-mono-700 mb-2">Password</label>
            <input type="password" id="password" name="password" required 
                   class="w-full px-4 py-2 border border-mono-300 rounded-lg focus:ring-2 focus:ring-mono-500 focus:border-mono-500 outline-none"
                   placeholder="••••••••">
        </div>

        <div class="flex items-center justify-between">
            <div class="flex items-center">
                <input type="checkbox" id="remember" name="remember" 
                       class="h-4 w-4 text-mono-600 focus:ring-mono-500 border-mono-300 rounded">
                <label for="remember" class="ml-2 block text-sm text-mono-600">Remember me</label>
            </div>
            <a href="forgot-password.php" class="text-sm text-mono-600 hover:text-mono-900">Forgot password?</a>
        </div>

        <button type="submit" 
                class="w-full bg-mono-900 text-white py-3 px-4 rounded-lg font-medium hover:bg-mono-800 focus:outline-none focus:ring-2 focus:ring-mono-500 focus:ring-offset-2 transition-colors">
            Sign in
        </button>
    </form>

    <div class="mt-6 text-center">
        <p class="text-sm text-mono-600">
            Don't have an account?
            <a href="register.php" class="font-medium text-mono-900 hover:text-mono-700">Sign up</a>
        </p>
    </div>
</div>

