-- Add is_superadmin field to users table
-- Check if column exists first to avoid errors

SET @col_exists = 0;
SELECT COUNT(*) INTO @col_exists 
FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA = DATABASE() 
  AND TABLE_NAME = 'users' 
  AND COLUMN_NAME = 'is_superadmin';

SET @sql = IF(@col_exists = 0,
  'ALTER TABLE `users` ADD COLUMN `is_superadmin` tinyint(1) NOT NULL DEFAULT 0 AFTER `email_verified_at`',
  'SELECT "Column is_superadmin already exists" AS message');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add index for superadmin queries
SET @idx_exists = 0;
SELECT COUNT(*) INTO @idx_exists 
FROM INFORMATION_SCHEMA.STATISTICS 
WHERE TABLE_SCHEMA = DATABASE() 
  AND TABLE_NAME = 'users' 
  AND INDEX_NAME = 'idx_is_superadmin';

SET @sql = IF(@idx_exists = 0,
  'ALTER TABLE `users` ADD KEY `idx_is_superadmin` (`is_superadmin`)',
  'SELECT "Index idx_is_superadmin already exists" AS message');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
