<?php

class Parser
{
    public static function detectBank($message)
    {
        $msg = strtolower($message);

        if (strpos($msg, "aba pay") !== false || strpos($msg, "trx. id:") !== false) {
            return "ABA";
        }
        if (strpos($msg, "rhb bank") !== false || strpos($msg, "reference no") !== false) {
            return "RHB";
        }

        return "UNKNOWN";
    }


    // -----------------------------
    //  Improved ABA Parser
    // -----------------------------
    public static function parseABA($message)
    {
        try {
            preg_match('/\$(\d+(\.\d+)?)/', $message, $amount);
            preg_match('/paid by ([^\(]+)/', $message, $payer);
            preg_match('/on (.*?) via/', $message, $datetime);
            preg_match('/at (.*?)\./', $message, $merchant);
            preg_match('/Trx\. ID: ([^,]+)/', $message, $trx);
            preg_match('/APV: (.*?)\./', $message, $apv);

            $dateTimeRaw = $datetime[1] ?? '';
            $dt = date("Y-m-d H:i:s", strtotime($dateTimeRaw));

            return [
                'bank'          => 'ABA',
                'payer_name'    => trim($payer[1] ?? ''),
                'amount'        => $amount[1] ?? 0,
                'date'          => date("Y-m-d", strtotime($dt)),
                'time'          => date("H:i:s", strtotime($dt)),
                'method'        => 'ABA PAY',
                'merchant'      => trim($merchant[1] ?? ''),
                'reference_id'  => trim($trx[1] ?? ''),
                'approval_code' => trim($apv[1] ?? ''),
            ];
        } catch (Exception $e) {
            Functions::logError("ABA PARSE ERROR: " . $e->getMessage());
            return false;
        }
    }


    // -----------------------------
    //  Improved RHB Parser
    // -----------------------------
    public static function parseRHB($message)
    {
        try {
            preg_match('/([\d\.]+) USD is paid by/', $message, $amount);
            preg_match('/paid by (.*?) on/', $message, $payer);
            preg_match('/on (.*?) - ([0-9:]+)/', $message, $dateTime);
            preg_match('/Outlet: (.*)/', $message, $merchant);
            preg_match('/Reference no: (.*)/', $message, $reference);

            return [
                'bank'          => 'RHB',
                'payer_name'    => trim($payer[1] ?? ''),
                'amount'        => $amount[1] ?? 0,
                'date'          => date("Y-m-d", strtotime($dateTime[1] ?? 'now')),
                'time'          => $dateTime[2] ?? '00:00:00',
                'method'        => 'FUND',
                'merchant'      => trim($merchant[1] ?? ''),
                'reference_id'  => trim($reference[1] ?? ''),
                'approval_code' => '',
            ];
        } catch (Exception $e) {
            Functions::logError("RHB PARSE ERROR: " . $e->getMessage());
            return false;
        }
    }
}
