# Payment Summary System 💰

A lightweight PHP application that tracks payment transactions from bank notifications via Telegram, stores them in a database, and provides beautiful summary reports.

## 🌟 Features

- **Multi-Bank Support**: Automatically parses payment notifications from ABA Bank and RHB Bank
- **Telegram Integration**: Receives payment notifications via Telegram webhook
- **Real-time Tracking**: Stores all transaction details in MySQL database
- **Summary Reports**: View daily, weekly, monthly, and yearly payment summaries
- **Transaction List**: Browse and search all transactions
- **Automatic Parsing**: Extracts payer name, amount, date, merchant, and reference information
- **Instant Confirmations**: Sends confirmation messages back to Telegram
- **Multi-Tenant Support**: Organizations with user authentication and role-based access

## 📋 Prerequisites

Before you begin, ensure you have the following installed:

- **PHP 7.4 or higher** (PHP 8.3+ recommended)
- **MySQL 5.7 or higher** (or MariaDB)
- **Web Server** (Apache/Nginx)
- **Telegram Bot** (for receiving payment notifications)

## 🚀 Installation Guide

### Step 1: Database Setup

**Option A: Using phpMyAdmin (Recommended for Laragon)**
1. Open Laragon → Click "Database" or go to `http://localhost/phpmyadmin`
2. Click "New" to create a database
3. Name it: `sumtel` (or your preferred name)
4. Click "Import" tab
5. Select file: `database/migrate_all.sql`
6. Click "Go"

**Option B: Using MySQL Command Line**
```bash
mysql -u root -p
```
Then run:
```sql
CREATE DATABASE sumtel;
USE sumtel;
SOURCE C:/laragon/www/payments/database/migrate_all.sql;
```

**Option C: Using PHP Migration Script**
```bash
php database/migrate.php
```

This will create all required tables:
- `users` - User accounts
- `organizations` - Multi-tenant organizations
- `organization_users` - User-organization relationships
- `password_resets` - Password reset tokens
- `telegram_access` - Telegram bot access
- `plans` - Subscription plans
- `subscriptions` - Organization subscriptions
- `transactions` - Payment transactions

### Step 2: Configure Environment Variables

1. Create a `.env` file in the root directory:
```env
# Database Configuration
DB_HOST=localhost
DB_NAME=sumtel
DB_USER=root
DB_PASS=

# Application Configuration
APP_NAME=Payment Summary System
APP_URL=http://localhost/payments/public
APP_TIMEZONE=Asia/Phnom_Penh
APP_ENV=development
APP_DEBUG=true

# Telegram Bot Configuration
TELEGRAM_BOT_TOKEN=YOUR_TELEGRAM_BOT_TOKEN_HERE
```

2. Update the values according to your setup:
   - `DB_NAME`: Your database name
   - `DB_USER`: Your MySQL username (usually `root` for Laragon)
   - `DB_PASS`: Your MySQL password (usually empty for Laragon)
   - `TELEGRAM_BOT_TOKEN`: Your Telegram bot token (see Step 3)

### Step 3: Configure Telegram Bot

1. **Create a Telegram Bot:**
   - Open Telegram and search for `@BotFather`
   - Send `/newbot` command
   - Follow the instructions to create your bot
   - Copy the **Bot Token** you receive

2. **Update `.env` file:**
   - Replace `YOUR_TELEGRAM_BOT_TOKEN_HERE` with your actual bot token

3. **Set up webhook:**
   - For local testing, use ngrok (see Testing section)
   - For production, use your domain:
   ```
   https://api.telegram.org/botYOUR_BOT_TOKEN/setWebhook?url=https://YOUR_DOMAIN/public/webhook.php
   ```
   - Visit this URL in your browser to register the webhook

### Step 4: Configure Web Server

#### If using Laragon:

1. Your project is already in the correct location: `C:\laragon\www\payments`
2. The web server document root should point to the `public` folder
3. Access the application at: `http://localhost/payments/public/` or `http://payments.test/` (if you've set up virtual host)

#### Apache Configuration (Optional - for cleaner URLs):

Create a `.htaccess` file in the `public` folder:
```apache
<IfModule mod_rewrite.c>
    RewriteEngine On
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteRule ^(.*)$ index.php [QSA,L]
</IfModule>
```

### Step 5: Set Permissions (Linux/Mac only)

```bash
chmod -R 755 storage/
chmod -R 755 storage/logs/
chmod -R 755 storage/cache/
```

### Step 6: Verify Installation

Visit: `http://localhost/payments/public/install-check.php`

This will verify:
- ✅ PHP version
- ✅ Database connection
- ✅ Required files
- ✅ File permissions
- ✅ Configuration files

## 🎯 Usage

### Accessing the Application

1. **Register/Login**: `http://localhost/payments/public/register.php` or `http://localhost/payments/public/login.php`
2. **Dashboard**: `http://localhost/payments/public/`
3. **Transaction List**: `http://localhost/payments/public/transaction-list.php`
4. **Summary Reports**: `http://localhost/payments/public/summary.php`
   - Daily Report
   - Weekly Report
   - Monthly Report
   - Yearly Report

### First Time Setup

1. **Register a new account** at `/register.php`
2. **Create an organization** (or join an existing one)
3. **Configure Telegram bot** for your organization (optional)
4. **Start receiving payments** via Telegram webhook

### Testing the Webhook

Send a test payment message to your Telegram bot:

**ABA Bank Format:**
```
$10.50 paid by John Doe (012345678) on Dec 3, 2025 at 10:30 AM via ABA PAY at ABC Store. Trx. ID: TRX123456, APV: APV789012.
```

**RHB Bank Format:**
```
15.75 USD is paid by Jane Smith on 03-12-2025 - 14:30:00. Outlet: XYZ Shop. Reference no: REF987654
```

The system will:
1. Receive the message
2. Parse the payment details
3. Store in database
4. Send a confirmation message back to Telegram

### Local Testing with Telegram

Since Telegram webhooks need a public URL, use **ngrok** for local testing:

1. **Install ngrok:** https://ngrok.com/download
2. **Start your server** (Laragon should handle this)
3. **Run ngrok:**
   ```bash
   ngrok http 80
   ```
4. **Copy the HTTPS URL** (e.g., `https://abc123.ngrok.io`)
5. **Set webhook:**
   ```
   https://api.telegram.org/botYOUR_TOKEN/setWebhook?url=https://abc123.ngrok.io/payments/public/webhook.php
   ```

## 📂 Project Structure

```
payments/
├── app/
│   ├── Auth/              # Authentication system
│   │   ├── Controllers/   # Auth controllers
│   │   └── Middleware/    # Auth middleware
│   ├── Config/            # Configuration files
│   │   ├── app.php       # App settings & Telegram token
│   │   └── db.php        # Database connection
│   ├── Controllers/       # Business logic
│   ├── Helpers/           # Utility functions & parsers
│   ├── Models/            # Database models
│   └── Services/          # External services (Telegram)
├── database/
│   ├── migrations/        # Database schema files
│   ├── seeders/           # Sample data
│   ├── migrate_all.sql    # Complete migration script
│   └── migrate.php        # PHP migration runner
├── public/                # Web accessible files
│   ├── assets/            # Images and resources
│   ├── css/               # Stylesheets
│   ├── js/                # JavaScript files
│   └── *.php              # Entry points
├── routes/
│   └── web.php            # Routing and autoloading
├── storage/
│   ├── cache/             # Cache files
│   └── logs/              # Application logs
├── tests/                 # Test files
└── views/                 # HTML templates
    ├── components/
    ├── layouts/
    ├── summary/
    └── transactions/
```

## 🔧 Troubleshooting

### Database Connection Failed
- Check your `.env` file database credentials
- Ensure MySQL service is running
- Verify the database exists
- Check `storage/logs/system.log` for detailed errors

### Telegram Not Receiving Messages
- Verify your bot token in `.env` file
- Check that webhook is properly set up
- Ensure your server is publicly accessible (use ngrok for local testing)
- Review logs in `storage/logs/system.log`

### Webhook Not Working
- Check `storage/logs/system.log` for error messages
- Ensure `public/webhook.php` is accessible
- Verify PHP can write to `storage/logs/` directory
- Test webhook URL directly in browser

### Parse Errors
- Check the format of your payment messages
- Review `app/Helpers/Parser.php` for supported formats
- Check logs in `storage/logs/system.log`

### Page Not Found or 404
- Ensure you're accessing `/public/` folder
- Check Laragon Apache/Nginx is running
- Verify file permissions
- Check `.htaccess` file exists in `public/` folder

### Environment Variables Not Loading
- Ensure `.env` file exists in root directory
- Check file permissions on `.env`
- Verify `app/Helpers/Env.php` is working correctly

## 🧪 Testing

### Test Database Connection
Create a test file `test-db.php` in `public/`:
```php
<?php
require_once __DIR__ . '/../app/Config/db.php';
echo "Database connected successfully!";
?>
```
Visit: `http://localhost/payments/public/test-db.php`

### Test Parser
```bash
php tests/parser-test.php
```

### Test Installation
Visit: `http://localhost/payments/public/install-check.php`

## 📝 Supported Payment Formats

### ABA Bank
The system recognizes ABA Pay notifications with the following pattern:
- Amount in USD (with $ symbol)
- Payer name and phone
- Date and time
- Merchant name
- Transaction ID
- Approval code

### RHB Bank
The system recognizes RHB Bank notifications with:
- Amount in USD
- Payer name
- Date and time
- Outlet/merchant name
- Reference number

## 🛠️ Technologies Used

- **PHP 7.4+**: Server-side programming
- **MySQL**: Database management
- **Telegram Bot API**: Webhook integration
- **HTML/CSS/JavaScript**: Frontend interface
- **PDO**: Database abstraction layer

## 📊 Database Migration

### Quick Migration
Run all migrations at once:
```bash
php database/migrate.php
```

Or import SQL file:
```sql
SOURCE database/migrate_all.sql;
```

### Verify Tables
```sql
SHOW TABLES;
```

You should see:
- `users`
- `organizations`
- `organization_users`
- `password_resets`
- `telegram_access`
- `plans`
- `subscriptions`
- `transactions`

## 🔐 Authentication & Multi-Tenancy

The system supports:
- User registration and login
- Password reset functionality
- Organization-based multi-tenancy
- Role-based access control (Owner, Admin, Member, Viewer)
- Organization-specific Telegram bot configuration

## 🛡️ Security Features

The application includes comprehensive security measures:
- **CSRF Protection**: All forms protected with CSRF tokens
- **Rate Limiting**: Login and webhook endpoints protected against brute-force attacks
- **XSS Prevention**: All user input properly escaped and sanitized
- **SQL Injection Prevention**: PDO prepared statements used throughout
- **Session Security**: Secure session management with regeneration on login
- **Security Headers**: HTTP security headers configured automatically
- **Input Validation**: Comprehensive validation and sanitization
- **Webhook Security**: Secret token validation and rate limiting

For detailed security documentation, see [SECURITY.md](SECURITY.md).

## 🚀 Production Deployment

### Quick Deploy to cPanel

For cPanel hosting, see the deployment guides:
- **[CPANEL_QUICK_START.md](CPANEL_QUICK_START.md)** - Quick 5-minute setup guide
- **[CPANEL_DEPLOYMENT.md](CPANEL_DEPLOYMENT.md)** - Complete step-by-step guide
- **[DEPLOYMENT_CHECKLIST.md](DEPLOYMENT_CHECKLIST.md)** - Deployment checklist

### Key Production Steps

1. Upload files to cPanel
2. Create database and import schema
3. Configure `.env` file with production values
4. Set file permissions (`storage/` → 755, `.env` → 600)
5. Enable HTTPS redirect in `.htaccess`
6. Configure Telegram webhook
7. Test installation: `/public/install-check.php`

See [CPANEL_DEPLOYMENT.md](CPANEL_DEPLOYMENT.md) for detailed instructions.

## 📞 Support

If you encounter any issues:
1. Check the logs in `storage/logs/system.log`
2. Review your `.env` configuration file
3. Ensure all prerequisites are installed
4. Verify database and Telegram bot are properly configured
5. Run installation checker: `public/install-check.php`
6. For cPanel deployment issues, see [CPANEL_DEPLOYMENT.md](CPANEL_DEPLOYMENT.md)

## 📄 License

This project is open-source and available for personal and commercial use.

---

**Made with ❤️ for efficient payment tracking**
