# cPanel Deployment Guide
## Payment Summary System

Complete step-by-step guide for deploying the Payment Summary System to cPanel hosting.

---

## 📋 Prerequisites

Before starting, ensure you have:
- ✅ cPanel hosting account with SSH access (recommended) or File Manager access
- ✅ PHP 7.4 or higher (PHP 8.3+ recommended)
- ✅ MySQL 5.7+ or MariaDB 10.3+
- ✅ SSL certificate installed (required for Telegram webhooks)
- ✅ Domain name configured
- ✅ FTP/SFTP credentials or cPanel File Manager access

---

## 🚀 Step-by-Step Deployment

### Step 1: Prepare Files Locally

1. **Clean up development files** (optional but recommended):
   ```bash
   # Remove test files
   rm -rf tests/
   rm -f QUICKSTART.txt
   ```

2. **Create production .env file**:
   - Copy `.env.example` to `.env`
   - Update with production values (see Step 3)

3. **Verify all files are ready**:
   - All source code files
   - `database/migrate_all.sql` or `database/migrate.php`
   - `.htaccess` files in place

---

### Step 2: Upload Files to cPanel

#### Option A: Using cPanel File Manager

1. **Log in to cPanel**
2. **Open File Manager**
3. **Navigate to `public_html`** (or your domain's root directory)
4. **Create a folder** for your application (e.g., `payments` or use root)
5. **Upload all files**:
   - Select all files from your local project
   - Upload via File Manager's upload feature
   - **Important**: Maintain folder structure

#### Option B: Using FTP/SFTP

1. **Connect via FTP client** (FileZilla, WinSCP, etc.)
2. **Navigate to `public_html`** (or your domain's root)
3. **Upload entire project folder** maintaining structure:
   ```
   public_html/
   └── payments/  (or root)
       ├── app/
       ├── database/
       ├── public/
       ├── storage/
       ├── views/
       └── ...
   ```

#### Option C: Using Git (if available)

```bash
# SSH into your cPanel account
cd ~/public_html
git clone your-repository-url payments
cd payments
```

**Important File Structure for cPanel:**
- If deploying to subdirectory: `public_html/payments/`
- If deploying to root: `public_html/` (move `public/` contents to root)

---

### Step 3: Create Database

1. **Log in to cPanel**
2. **Open "MySQL Databases"**
3. **Create Database**:
   - Enter database name (e.g., `username_payments`)
   - Click "Create Database"
   - **Note the full database name** (usually `username_dbname`)

4. **Create Database User**:
   - Enter username (e.g., `username_payuser`)
   - Generate strong password
   - Click "Create User"
   - **Note the full username** (usually `username_dbuser`)

5. **Add User to Database**:
   - Select user and database
   - Click "Add"
   - Grant "ALL PRIVILEGES"
   - Click "Make Changes"

---

### Step 4: Import Database

#### Option A: Using phpMyAdmin

1. **Open phpMyAdmin** in cPanel
2. **Select your database** from left sidebar
3. **Click "Import" tab**
4. **Choose file**: `database/migrate_all.sql`
5. **Click "Go"**
6. **Verify tables created**:
   - `users`
   - `organizations`
   - `organization_users`
   - `password_resets`
   - `telegram_access`
   - `plans`
   - `subscriptions`
   - `transactions`

#### Option B: Using Command Line (SSH)

```bash
cd ~/public_html/payments
mysql -u username_dbuser -p username_payments < database/migrate_all.sql
```

#### Option C: Using PHP Script

```bash
cd ~/public_html/payments
php database/migrate.php
```

---

### Step 5: Configure Environment Variables

1. **Create `.env` file** in project root:
   ```env
   # Application Configuration
   APP_NAME="Payment Summary System"
   APP_URL="https://yourdomain.com/payments/public"
   APP_TIMEZONE="Asia/Phnom_Penh"
   APP_ENV="production"
   APP_DEBUG="false"

   # Database Configuration
   DB_HOST="localhost"
   DB_NAME="username_payments"
   DB_USER="username_payuser"
   DB_PASS="your_secure_password_here"

   # Telegram Bot Configuration
   TELEGRAM_BOT_TOKEN="your_telegram_bot_token_here"
   TELEGRAM_WEBHOOK_SECRET="your_webhook_secret_here"

   # Security Settings
   VALIDATE_TELEGRAM_IP="false"
   ```

2. **Generate Webhook Secret**:
   ```bash
   # Via SSH
   php -r "echo bin2hex(random_bytes(32));"
   
   # Or use online generator
   # Copy the generated value to TELEGRAM_WEBHOOK_SECRET
   ```

3. **Set file permissions** (via File Manager or SSH):
   ```bash
   chmod 600 .env
   ```

---

### Step 6: Set File Permissions

#### Using cPanel File Manager:

1. **Right-click `storage/` folder** → Change Permissions
2. **Set to `755`** (or `775` if needed)
3. **Repeat for**:
   - `storage/logs/` → `755`
   - `storage/cache/` → `755`
   - `.env` → `600`

#### Using SSH:

```bash
cd ~/public_html/payments
chmod -R 755 storage/
chmod -R 755 storage/logs/
chmod -R 755 storage/cache/
chmod 600 .env
chmod 644 .htaccess
```

---

### Step 7: Configure Document Root

#### If deploying to subdirectory (`/payments/`):

**No changes needed** - Access at: `https://yourdomain.com/payments/public/`

#### If deploying to root domain:

1. **Move public folder contents to root**:
   ```bash
   # Via SSH
   cd ~/public_html/payments
   mv public/* ../../
   mv public/.htaccess ../../
   ```

2. **Update `.env` APP_URL**:
   ```env
   APP_URL="https://yourdomain.com"
   ```

3. **Update paths in `routes/web.php`** if needed

---

### Step 8: Enable HTTPS Redirect

1. **Edit `.htaccess` in root** (or `public/` if using subdirectory)
2. **Uncomment HTTPS redirect**:
   ```apache
   <IfModule mod_rewrite.c>
       RewriteEngine On
       
       # Force HTTPS in production
       RewriteCond %{HTTPS} off
       RewriteCond %{HTTP:X-Forwarded-Proto} !https
       RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
   </IfModule>
   ```

---

### Step 9: Configure PHP Version

1. **Open "Select PHP Version"** in cPanel
2. **Select PHP 7.4 or higher** (8.3+ recommended)
3. **Enable required extensions**:
   - ✅ PDO
   - ✅ PDO_MySQL
   - ✅ JSON
   - ✅ mbstring
   - ✅ curl
   - ✅ openssl

4. **Set PHP settings** (if available):
   ```ini
   display_errors = Off
   log_errors = On
   error_reporting = E_ALL & ~E_DEPRECATED & ~E_STRICT
   ```

---

### Step 10: Set Up Telegram Webhook

1. **Get your webhook URL**:
   ```
   https://yourdomain.com/payments/public/webhook.php
   ```

2. **Set webhook via Telegram API**:
   ```
   https://api.telegram.org/botYOUR_BOT_TOKEN/setWebhook?url=https://yourdomain.com/payments/public/webhook.php&secret_token=YOUR_WEBHOOK_SECRET
   ```

3. **Verify webhook**:
   ```
   https://api.telegram.org/botYOUR_BOT_TOKEN/getWebhookInfo
   ```

4. **Test webhook**:
   - Send a test payment message to your bot
   - Check `storage/logs/system.log` for activity

---

### Step 11: Create Admin User

#### Option A: Using Registration Page

1. **Visit**: `https://yourdomain.com/payments/public/register.php`
2. **Register new account**
3. **Create organization**

#### Option B: Using Database (SSH)

```bash
cd ~/public_html/payments
php -r "
require 'app/Config/db.php';
\$password = password_hash('your_admin_password', PASSWORD_DEFAULT);
\$stmt = \$pdo->prepare('INSERT INTO users (name, email, password_hash, created_at) VALUES (?, ?, ?, NOW())');
\$stmt->execute(['Admin User', 'admin@yourdomain.com', \$password]);
echo 'Admin user created!';
"
```

---

### Step 12: Test Installation

1. **Visit installation checker**:
   ```
   https://yourdomain.com/payments/public/install-check.php
   ```

2. **Verify all checks pass**:
   - ✅ PHP version
   - ✅ Database connection
   - ✅ Required files
   - ✅ File permissions
   - ✅ Configuration files

3. **Test login**: `https://yourdomain.com/payments/public/login.php`

4. **Test webhook**: Send test message to Telegram bot

---

## 🔒 Security Checklist

- [ ] `.env` file permissions set to `600`
- [ ] `APP_ENV` set to `"production"`
- [ ] `APP_DEBUG` set to `"false"`
- [ ] HTTPS redirect enabled in `.htaccess`
- [ ] SSL certificate installed and working
- [ ] Database credentials are secure
- [ ] Webhook secret token generated
- [ ] Storage directories writable (`755`)
- [ ] `.env` file protected from web access
- [ ] Default passwords changed
- [ ] Security headers verified (check with browser dev tools)

---

## 🛠️ cPanel-Specific Configuration

### File Manager Settings

1. **Show Hidden Files**:
   - File Manager → Settings → Show Hidden Files (dotfiles)

2. **Enable .htaccess**:
   - Usually enabled by default
   - If issues, contact hosting support

### Cron Jobs (Optional - for backups)

1. **Open "Cron Jobs"** in cPanel
2. **Add daily database backup**:
   ```bash
   0 2 * * * /usr/bin/mysqldump -u username_dbuser -p'password' username_payments > ~/backups/db_$(date +\%Y\%m\%d).sql
   ```

### Error Logs

- **Location**: `~/public_html/payments/storage/logs/system.log`
- **View via**: File Manager or SSH
- **cPanel Error Log**: Home → Metrics → Errors

---

## 🔧 Troubleshooting

### Issue: 500 Internal Server Error

**Solutions:**
1. Check `.htaccess` syntax
2. Verify PHP version (7.4+)
3. Check file permissions
4. Review error logs: `storage/logs/system.log`
5. Check cPanel error log

### Issue: Database Connection Failed

**Solutions:**
1. Verify database credentials in `.env`
2. Check database name format (usually `username_dbname`)
3. Verify user has permissions
4. Test connection via phpMyAdmin

### Issue: Files Not Writable

**Solutions:**
1. Set permissions: `chmod 755 storage/`
2. Check ownership (may need to contact hosting)
3. Verify directory exists: `storage/logs/`, `storage/cache/`

### Issue: Webhook Not Working

**Solutions:**
1. Verify HTTPS is working
2. Check webhook URL is accessible
3. Verify `TELEGRAM_WEBHOOK_SECRET` matches
4. Check `storage/logs/system.log`
5. Test webhook endpoint directly

### Issue: CSS/JS Not Loading

**Solutions:**
1. Check file paths in views
2. Verify `public/` directory structure
3. Clear browser cache
4. Check `.htaccess` for rewrite rules

---

## 📊 Post-Deployment

### 1. Monitor Logs

- Check `storage/logs/system.log` regularly
- Monitor cPanel error logs
- Set up log rotation if needed

### 2. Performance

- Enable OPcache (if available)
- Monitor database performance
- Check slow query log

### 3. Backups

- Set up automated database backups
- Backup `.env` file securely
- Regular file backups

### 4. Updates

- Keep PHP updated
- Monitor security advisories
- Update application code regularly

---

## 📞 Support

If you encounter issues:

1. **Check logs**: `storage/logs/system.log`
2. **Review documentation**: 
   - [README.md](README.md)
   - [CONFIGURATION.md](CONFIGURATION.md)
   - [SECURITY.md](SECURITY.md)
3. **Test installation**: `install-check.php`
4. **Contact hosting support** for server-level issues

---

## 🎯 Quick Reference

### Important URLs

- **Application**: `https://yourdomain.com/payments/public/`
- **Login**: `https://yourdomain.com/payments/public/login.php`
- **Webhook**: `https://yourdomain.com/payments/public/webhook.php`
- **Install Check**: `https://yourdomain.com/payments/public/install-check.php`

### Important Files

- **Configuration**: `.env`
- **Logs**: `storage/logs/system.log`
- **Database**: `database/migrate_all.sql`

### Important Commands (SSH)

```bash
# Check PHP version
php -v

# Test database connection
php -r "require 'app/Config/db.php'; echo 'Connected!';"

# View logs
tail -f storage/logs/system.log

# Set permissions
chmod -R 755 storage/
chmod 600 .env
```

---

**Last Updated**: 2024  
**Version**: 1.0
